uniform vec2 u_texSize;
uniform vec2 u_gridSize;
uniform vec2 u_cellSize;
varying vec2 v_texCoord;

void main()
{
    vec4 BLACK = vec4(0.0, 0.0, 0.0, 0.0);
    vec2 cell = floor(v_texCoord * u_gridSize);
    
    vec4 OWN = texture2D(CC_Texture1, cell / u_texSize);
    if (OWN != BLACK)
    {
        gl_FragColor = OWN;
        return;
    }
    
    float aspectRatio = u_gridSize.x / u_gridSize.y;
    float fake3D = 0.45;
    float fake3DTintTop = 0.8;
    float fake3DTintRight = 0.6;
    
    vec2 cellCorner = cell * u_cellSize;
    
    vec2 fake3Dpx = u_cellSize * fake3D;
    vec2 inner = gl_FragCoord.xy - cell * u_cellSize;
    vec2 displacement = vec2(0.0, 0.0);
    
    if (inner.x < fake3Dpx.x)
    {
        if (inner.y < fake3Dpx.y)
        {
            if (inner.x > inner.y)
            {
                displacement.x = cellCorner.x + inner.x;
                displacement.y = cellCorner.y - 1.0;
                displacement = floor(displacement / u_cellSize);
                vec4 col = texture2D(CC_Texture1, displacement / u_texSize) * fake3DTintTop;
                if (col == BLACK)
                {
                    displacement.x = cellCorner.x - 1.0;
                    displacement.y = cellCorner.y - inner.y;
                    displacement = floor(displacement / u_cellSize);
                    gl_FragColor = texture2D(CC_Texture1, displacement / u_texSize) * fake3DTintRight;
                    return;
                }
                else
                {
                    gl_FragColor = col;
                    return;
                }
            }
            else
            {
                displacement.x = cellCorner.x - 1.0;
                displacement.y = cellCorner.y + inner.y;
                displacement = floor(displacement / u_cellSize);
                vec4 col = texture2D(CC_Texture1, displacement / u_texSize) * fake3DTintRight;
                if (col == BLACK)
                {
                    displacement.x = cellCorner.x - 1.0;
                    displacement.y = cellCorner.y - 1.0;
                    displacement = floor(displacement / u_cellSize);
                    gl_FragColor = texture2D(CC_Texture1, displacement / u_texSize) * fake3DTintTop;
                    return;
                }
                else
                {
                    gl_FragColor = col;
                    return;
                }
            }
        }
        else
        {
            displacement.x = cellCorner.x - 1.0;
            displacement.y = cellCorner.y + inner.y;
            displacement = floor(displacement / u_cellSize);
            gl_FragColor = texture2D(CC_Texture1, displacement / u_texSize) * fake3DTintRight;
            return;
        }
    }
    else if (inner.y < fake3Dpx.y)
    {
        displacement.x = cellCorner.x + inner.y;
        displacement.y = cellCorner.y - 1.0;
        displacement = floor(displacement / u_cellSize);
        gl_FragColor = texture2D(CC_Texture1, displacement / u_texSize) * fake3DTintTop;
        return;
    }
    gl_FragColor = vec4(0.0, 0.0, 0.0, 0.0);
}
 